<?php
if (!function_exists('blockwp_menu_section_start')) {
    /**
     * Add start div to menu secction below main header.
     *
     * @since 1.0.0
     */
    function blockwp_menu_section_start()
    {
?>
        <div class="menu-wrapper">
            <div class="container">
                <div class="container-inner" id="ct-menu-container">
                <?php
            }
        }
        add_action('blockwp_menu_section', 'blockwp_menu_section_start', 10);

        if (!function_exists('blockwp_mobile_top_menu_block_start')) {
            /**
             * Add div start for mobile menu top block wrapper
             *
             * @since 1.0.0
             */
            function blockwp_mobile_top_menu_block_start()
            {
                ?>
                    <div class="ct-mobile-top-menu-wrapper">
                        <?php
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_mobile_top_menu_block_start', 15);

                if (!function_exists('blockwp_offcanvas_menu')) {
                    /**
                     * Add offcanvas menu on main menu
                     *
                     * @since 1.0.0
                     */
                    function blockwp_offcanvas_menu()
                    {
                        if (1 == get_theme_mod('blockwp_enable_offcanvas', 0)) {
                        ?>
                            <div class="offcanvas-menu-wrapper">
                                <a href="#" class="offcanvas-toggle"><span></span> </a>
                            </div>
                        <?php
                        }
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_offcanvas_menu', 15);

                if (!function_exists('blockwp_menu_search_mobile')) {
                    /**
                     * Add search on main menu section for mobile
                     *
                     * @since 1.0.0
                     */
                    function blockwp_menu_search_mobile()
                    {
                        if (1 == get_theme_mod('blockwp_enable_search', 0)) {
                        ?>
                            <div class="overlay-search-wrapper text-center mbl-show">
                                <a href="#" class="search-toggle"> <i class="fas fa-search"></i> </a>
                            </div>
                        <?php
                        }
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_menu_search_mobile', 20);

                if (!function_exists('blockwp_toggle_menu')) {
                    /**
                     * Add toggle menu for mobile
                     *
                     * @since 1.0.0
                     */
                    function blockwp_toggle_menu()
                    {
                        ?>
                        <div class="menu-toggle-wrapper text-right">

                            <button class="menu-toggle" id="ct-menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                <i class="fas fa-bars"></i>
                            </button>
                        </div>
                    <?php
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_toggle_menu', 20);

                if (!function_exists('blockwp_mobile_top_menu_block_end')) {
                    /**
                     * Add div end for mobile menu top block wrapper
                     *
                     * @since 1.0.0
                     */
                    function blockwp_mobile_top_menu_block_end()
                    {
                    ?>
                    </div>
                <?php
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_mobile_top_menu_block_end', 20);

                if (!function_exists('blockwp_main_menu')) {
                    /**
                     * Add main menu
                     *
                     * @since 1.0.0
                     */
                    function blockwp_main_menu()
                    {
                ?>
                    <nav id="site-navigation" class="main-navigation">
                        <?php wp_nav_menu([
                            'theme_location' => 'menu-1',
                            'menu_id' => 'primary-menu',
                        ]); ?>
                    </nav><!-- #site-navigation -->
                    <?php
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_main_menu', 20);

                if (!function_exists('blockwp_menu_search')) {
                    /**
                     * Add search on main menu section
                     *
                     * @since 1.0.0
                     */
                    function blockwp_menu_search()
                    {
                        if (1 == get_theme_mod('blockwp_enable_search', 0)) {
                    ?>
                        <div class="overlay-search-wrapper text-right mbl-hide">
                            <a href="#" class="search-toggle"> <i class="fas fa-search"></i> </a>

                        </div>
                        <section class="search-section">
                            <div class="container">
                                <button class="close-btn"><i class="fa fa-times"></i></button>
                                <?php get_search_form(); ?>
                            </div>
                        </section>
                    <?php
                        }
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_menu_search', 25);


                if (!function_exists('blockwp_menu_section_end')) {
                    /**
                     * Add end div to menu secction below main header.
                     *
                     * @since 1.0.0
                     */
                    function blockwp_menu_section_end()
                    {
                    ?>

                </div>
            </div>
        </div> <!-- .menu-wrapper -->
    <?php
                    }
                }
                add_action('blockwp_menu_section', 'blockwp_menu_section_end', 30);

                if (!function_exists('blockwp_main_header_wrapper_end')) {
                    /**
                     * Add end div to menu secction below main header.
                     *
                     * @since 1.0.0
                     */
                    function blockwp_main_header_wrapper_end()
                    {
    ?>
        </div> <!-- .site-main-header-wrapper -->
<?php
                    }
                }
                add_action('blockwp_after_main_header_navigation', 'blockwp_main_header_wrapper_end', 10);

                add_filter('wp_nav_menu_items', 'blockwp_add_extra_item_to_nav_menu', 10, 2);
                if (!function_exists('blockwp_add_extra_item_to_nav_menu')) {
                    function blockwp_add_extra_item_to_nav_menu($items, $args)
                    {
                        $menu_location = 'menu-1';

                        if (!empty($menu_location) && $args->theme_location == $menu_location) {
                            $items .= '<li class="nav-item ct-nav-item">';
                            $items .= '<a class="nav-link close_nav" href="#"><i class="fa fa-times"></i></a>';
                            $items .= '</li>';
                        }

                        return $items;
                    }
                }
